function [] = writing_outputs(units,Hi_slope,Lo_slope,new_geo,new_geo_p,...
    c_r,f_r,c_p,f_p,D50,func_choice,n_chunks,final_rows,n_ranges,...
    firstCol,eco_func_per_chunk,matrix,spaces,julian_day,Q,tau_star,...
    Q_star,eco_names,GMF,real_F,n_eco_func,total_days_GMF,total_days_F,...
    start_day,end_day,D50_choice,n_gs,gs_range,...
    c_r_H,f_r_H,w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r,...
    c_p_H,f_p_H,w_p_Man,A_p_Man,P_p_Man,R_p_Man,V_p_Man,Q_p_Man,H_p_Man,stage_p,Hi_slope_p,Lo_slope_p,...
    t_store,Q_store,tau_thresh,tau_is_pos)

%% Some user input
disp(' ')
disp(' ')
disp('<<<<    Data Output File    >>>>')
disp(' ')
out_file_name = input('Please enter the name of the output data file, INCLUDING the .txt, .dat, .mat, etc. extension:  ','s');

name_choice = 0;
disp(' ')
disp('Would you like to name this specific analysis?')
disp('1. Yes')
disp('2. No')

while name_choice ~= 1 && name_choice ~= 2
    disp(' ')
    name_choice = input('Please enter either 1 or 2:  ');
    disp(' ')
end

if name_choice == 1
    disp(' ')
    analysis_name = input('Please enter a name for this analysis:  ','s');
    disp(' ')
end

fid = fopen(out_file_name,'wt');

%% Displays a heading
if name_choice == 1
    fprintf(fid,'<<<< Output Data for %s >>>>\n',analysis_name);
else
    fprintf(fid,'<<<< Output Data >>>>\n');
end

date_store = fix(clock);
fprintf(fid,'\n');

%% Displays the date and time
fprintf(fid,'**Date:  %0.0f/%0.0f/%0.0f\n',date_store(2),date_store(3),date_store(1));

%Case for am or pm
if date_store(4) >= 12
    
    %case for minutes less than 10
    if date_store(5) < 10        
        fprintf(fid,'**Time:  %0.0f:0%0.0f pm\n',date_store(4)-12,date_store(5));
    else
        fprintf(fid,'**Time:  %0.0f:%0.0f pm\n',date_store(4)-12,date_store(5));
    end
    
else

    %case for minutes less than 10
    if date_store(5) < 10
        fprintf(fid,'**Time:  %0.0f:0%0.0f am\n',date_store(4),date_store(5));
    else
        fprintf(fid,'**Time:  %0.0f:%0.0f am\n',date_store(4),date_store(5));
    end
end

%% Units
fprintf(fid,'\n');
fprintf(fid,'**Units:  ');
if units == 1
    fprintf(fid,'Metric\n');
else
    fprintf(fid,'English\n');
end

%% Slope
fprintf(fid,'\n**Slope\nRiffle');

if Hi_slope_p
    fprintf(fid,'                        \t\tPool\n');
else
    fprintf(fid,'\n');
end

%case for constant riffle
if Hi_slope == Lo_slope
    fprintf(fid,'Constant: %12g',Hi_slope);
    
    if (Hi_slope_p == Lo_slope_p) && Hi_slope_p
        fprintf(fid,'           \tConstant: %12g\n',Hi_slope_p);    
    
    elseif (Hi_slope_p ~= Lo_slope_p)
        fprintf(fid,'\tHigh Stage Slope: %12g\n',Hi_slope_p);
        fprintf(fid,'                              \tLow Stage Slope: %12g\n',Lo_slope_p);
    else
        fprintf(fid,'\n');
    end
end

%case for riffle different
if Hi_slope ~= Lo_slope
    if (Hi_slope_p ~= Lo_slope_p) && Hi_slope_p
        fprintf(fid,'\nHigh Stage Slope: %12g\tHigh Stage Slope: %12g\n',Hi_slope,Hi_slope_p);
        fprintf(fid,'Low  Stage Slope: %12g\tLow  Stage Slope: %12g\n',Lo_slope,Lo_slope_p);
    elseif Hi_slope_p
        fprintf(fid,'\nHigh Stage Slope: %12g\tConstant: %12g\n',Hi_slope,Hi_slope_p);
        frpintf(fid,'\nLow  Stage Slope: %12g\n',Lo_slope);
    else
        fprintf(fid,'High Stage Slope: %12g\nLow  Stage Slope: %12g\n',Hi_slope,Lo_slope);
    end
end

%% Cross sectional geometry for riffle and pool

%case for the existance of riffle and pool xs geo
if length(new_geo) ~= 1 && length(new_geo_p) ~= 1

    fprintf(fid,'\n**Cross Sectional Geometry\n');
    fprintf(fid,'Riffle      \t            \t\tPool\n');
    if units == 1
        fprintf(fid,'   X (m)    \t    Y (m)   \t\t    X (m)   \t    Y (m)  \n');
    else
        fprintf(fid,'   X (ft)   \t    Y (ft)  \t\t    X (ft)  \t    Y (ft)  \n');
    end
    i = 1;
    
    %Write both columns as long as they both have data
    while i <= length(new_geo) && i <= length(new_geo_p)
        fprintf(fid,'%12g\t%12g\t\t',new_geo(i,1),new_geo(i,2));
        fprintf(fid,'%12g\t%12g\n',new_geo_p(i,1),new_geo_p(i,2));
        i = i + 1;
    end
    
    %Case for riffle having more xs geo entries than pool
    if length(new_geo) > length(new_geo_p)
        while i <= length(new_geo)
            fprintf(fid,'%12g\t%12g\n',new_geo(i,1),new_geo(i,2));
            i = i + 1;
        end
    end
    
    %Case for pool having more xs geo entries than riffle
    if length(new_geo_p) > length(new_geo)
        while i <= length(new_geo_p)
            fprintf(fid,'            \t            \t\t%12g\t%12g\n',new_geo_p(i,1),new_geo_p(i,2));
            i = i + 1;
        end
    end
    
%case for riffle geo but no pool geo
elseif length(new_geo) ~= 1 && length(new_geo_p) == 1
    new_geo = new_geo.';
    fprintf(fid,'\n**Cross Sectional Geometry\n');
    fprintf(fid,'Riffle\n');
    if units == 1
        fprintf(fid,'    X (m)   \t    Y (m)  \n');
    else
        fprintf(fid,'    X (ft)  \t    Y (ft) \n');
    end
    fprintf(fid,'%12g\t%12g\n',new_geo);

%case for pool but no riffle... not sure if this will ever happen, but hey,
%it can't hurt to code it
elseif length(new_geo) == 1 && length(new_geo_p) ~= 1
    new_geo_p = new_geo_p.';
    fprintf(fid,'\n**Cross Sectional Geometry\n');
    fprintf(fid,'Pool\n');
    if units == 1
        fprintf(fid,'    X (m)   \t     Y (m)  \n');
    else
        fprintf(fid,'    X (ft)  \t     Y (ft) \n');
    end
    fprintf(fid,'%12g\t%12g\n',new_geo_p);
end %end of xs geo if statement

%%  Mannings data for riffle and pool
%if the pool's mannings data exists
fprintf(fid,'\n');
if length(R_r_Man) ~= 1  && length(R_p_Man) ~= 1
    
    if units == 1
        fprintf(fid,'\n**Manning''s Data (unless otherwise noted, all dimensions in meters)');
        fprintf(fid,'\nRiffle      \t            \t            \t');
        fprintf(fid,'\t            \t            \t            \t            \t\t\t\tPool');
        fprintf(fid,'\n       Stage\t       Width\t   Perimeter\t       ');
        fprintf(fid,' Area\t       HYD R\t       HYD D\t     V (mps)\t     Q (cms)\t\t\t');

        fprintf(fid,'       Stage\t       Width\t   Perimeter\t       ');
        fprintf(fid,' Area\t       HYD R\t       HYD D\t     V (mps)\t     Q (cms)\n');
    else
        fprintf(fid,'\n**Manning''s Data (unless otherwise noted, all dimensions in feet)');
        fprintf(fid,'\nRiffle      \t            \t            \t');
        fprintf(fid,'\t            \t            \t            \t            \t\t\t\tPool');
        fprintf(fid,'\n       Stage\t       Width\t   Perimeter\t       ');
        fprintf(fid,' Area\t       HYD R\t       HYD D\t     V (fps)\t     Q (cfs)\t\t\t');

        fprintf(fid,'       Stage\t       Width\t   Perimeter\t       ');
        fprintf(fid,' Area\t       HYD R\t       HYD D\t     V (fps)\t     Q (cfs)\n');
    end
    
    i = 1;
    while i <= length(R_r_Man) && i <= length(R_p_Man)
        fprintf(fid,'%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t\t\t',...
            stage_r(i),w_r_Man(i),P_r_Man(i),A_r_Man(i),R_r_Man(i),H_r_Man(i),V_r_Man(i),Q_r_Man(i));

        fprintf(fid,'%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\n',...
            stage_p(i),w_p_Man(i),P_p_Man(i),A_p_Man(i),R_p_Man(i),H_p_Man(i),V_p_Man(i),Q_p_Man(i));
        i = i + 1;
    end
    
    %case for riffle having more entries than pool
    if length(R_r_Man) > length(R_p_Man)
        while i <= length(R_r_Man)
            fprintf(fid,'%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\n',...
                stage_r(i),w_r_Man(i),P_r_Man(i),A_r_Man(i),R_r_Man(i),H_r_Man(i),V_r_Man(i),Q_r_Man(i));
            i = i + 1;
        end
    end

    %case for pool having more entries than riffle
    if length(R_r_Man) < length(R_p_Man)
        while i <= length(R_p_Man)
            fprintf(fid,'            \t            \t            \t       ');
            fprintf(fid,'     \t            \t            \t            \t            \t\t\t');
            fprintf(fid,'%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\n',...
                stage_p(i),w_p_Man(i),P_p_Man(i),A_p_Man(i),R_p_Man(i),H_p_Man(i),V_p_Man(i),Q_p_Man(i));

            i = i + 1;
        end
    end

%case of mannings data for riffle, but not pool
elseif length(R_r_Man) ~= 1 && length(R_p_Man) == 1
    
    if units == 1
        fprintf(fid,'\n**Manning''s Data (unless otherwise noted, all dimensions in meters)');
        fprintf(fid,'\nRiffle');
        fprintf(fid,'\n       Stage\t       Width\t   Perimeter\t       ');
        fprintf(fid,' Area\t       HYD R\t       HYD D\t     V (mps)\t     Q (cms)\n');
    else
        fprintf(fid,'\n**Manning''s Data (unless otherwise noted, all dimensions in feet)');
        fprintf(fid,'\nRiffle');
        fprintf(fid,'\n       Stage\t       Width\t   Perimeter\t       ');
        fprintf(fid,' Area\t       HYD R\t       HYD D\t     V (fps)\t     Q (cfs)\n');
    end
    
    i = 1;
    while i <= length(R_r_Man)
        fprintf(fid,'%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\n',...
            stage_r(i),w_r_Man(i),P_r_Man(i),A_r_Man(i),R_r_Man(i),H_r_Man(i),V_r_Man(i),Q_r_Man(i));

        i = i + 1;
    end

%case for mannings data for pool but not riffle
elseif length(R_r_Man) == 1 && length(R_p_Man) ~= 1

    if units == 1
        fprintf(fid,'\n**Manning''s Data (unless otherwise noted, all dimensions in meters)');
        fprintf(fid,'\nPool');
        fprintf(fid,'\n       Stage\t       Width\t   Perimeter\t       ');
        fprintf(fid,' Area\t       HYD R\t       HYD D\t     V (mps)\t     Q (cms)\n');
    else
        fprintf(fid,'\n**Manning''s Data (unless otherwise noted, all dimensions in feet)');
        fprintf(fid,'\nPool');
        fprintf(fid,'\n       Stage\t       Width\t   Perimeter\t       ');
        fprintf(fid,' Area\t       HYD R\t       HYD D\t     V (fps)\t     Q (cfs)\n');
    end
    
    i = 1;
    while i <= length(R_p_Man)
        fprintf(fid,'%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\t%12g\n',...
            stage_p(i),w_p_Man(i),P_p_Man(i),A_p_Man(i),R_p_Man(i),H_p_Man(i),V_p_Man(i),Q_p_Man(i));

        i = i + 1;
    end
    
end %of large if statement

%showing the c's and f's
%if you have both sets from both riffle and pool
if c_p && f_p && c_p_H && f_p_H && c_r_H && f_r_H
    fprintf(fid,'\n');
    fprintf(fid,'\n**Manning''s Power Relation\n');
    fprintf(fid,'Riffle         \t\tPool\n');
    fprintf(fid,'c: %9.4f   \t\tc: %9.4f\n',c_r,c_p);
    fprintf(fid,'f: %9.4f   \t\tf: %9.4f\n',f_r,f_p);
    fprintf(fid,'(where R=cQ^f) \t\t(where R=cQ^f)\n');
    fprintf(fid,'\n');
    fprintf(fid,'c: %9.4f   \t\tc: %9.4f\n',c_r_H,c_p_H);
    fprintf(fid,'f: %9.4f   \t\tf: %9.4f\n',f_r_H,f_p_H);
    fprintf(fid,'(where H=cQ^f) \t\t(where H=cQ^f)\n');
    
%if you have only the H set from pool but both from riffle
elseif c_p_H && f_p_H && c_r_H && f_r_H
    fprintf(fid,'\n');
    fprintf(fid,'\n**Manning''s Power Relation\n');
    fprintf(fid,'Riffle         \t\tPool\n');
    fprintf(fid,'c: %9.4f\n',c_r);
    fprintf(fid,'f: %9.4f\n',f_r);
    fprintf(fid,'(where R=cQ^f) \n');
    fprintf(fid,'\n');
    fprintf(fid,'c: %9.4f   \t\tc: %9.4f\n',c_r_H,c_p_H);
    fprintf(fid,'f: %9.4f   \t\tf: %9.4f\n',f_r_H,f_p_H);
    fprintf(fid,'(where H=cQ^f) \t\t(where H=cQ^f)\n');
    
%if you have no pool data, but both for riffle
elseif c_r_H && f_r_H
    fprintf(fid,'\n');
    fprintf(fid,'\n**Manning''s Power Relation\n');
    fprintf(fid,'Riffle\n');
    fprintf(fid,'c: %9.4f\n',c_r);
    fprintf(fid,'f: %9.4f\n',f_r);
    fprintf(fid,'(where R=cQ^f) \n');
    fprintf(fid,'\n');
    fprintf(fid,'c: %9.4f\n',c_r_H);
    fprintf(fid,'f: %9.4f\n',f_r_H);
    fprintf(fid,'(where H=cQ^f)\n');

%if you only have the R sets for both
elseif c_p && f_p    
    fprintf(fid,'\n');
    fprintf(fid,'\n**Manning''s Power Relation\n');
    fprintf(fid,'Riffle         \t\tPool\n');
    fprintf(fid,'c: %9.4f   \t\tc: %9.4f\n',c_r,c_p);
    fprintf(fid,'f: %9.4f   \t\tf: %9.4f\n',f_r,f_p);
    fprintf(fid,'(where R=cQ^f) \t\t(where R=cQ^f)\n');

%the only thing you have is the R set for the riffle 
else
    fprintf(fid,'\n');
    fprintf(fid,'\n**Manning''s Power Relation\n');
    fprintf(fid,'Riffle\n');
    fprintf(fid,'c: %9.4f\n',c_r);
    fprintf(fid,'f: %9.4f\n',f_r);
    fprintf(fid,'(where R=cQ^f)\n');    
end

%% Grain Size
fprintf(fid,'\n');

if D50_choice == 1
    if units == 1
        D50 = D50*1000; % convert m to mm
    else
        D50 = D50/0.0032808399; % convert ft to mm
    end
    fprintf(fid,'\n**Grain Size: %12g mm\n',D50);
else
    fprintf(fid,'\n**Grain Size\n');
    fprintf(fid,'   Range (mm) \t # Measured\n');
    
    i = 1;
    fprintf(fid,'      < %5.1f \t %10.0f\n',gs_range(i),n_gs(i));
    
    for i = 2:length(gs_range)
        fprintf(fid,'%5.1f - %5.1f \t %10.0f\n',gs_range(i-1),gs_range(i),n_gs(i));
    end
    
    i = length(gs_range) + 1;
    fprintf(fid,'      > %5.1f \t %10.0f\n',gs_range(i-1),n_gs(i));
    
    if units == 1
        D50 = D50*1000; % convert m to mm
    else
        D50 = D50/0.0032808399; % convert ft to mm
    end
    
    fprintf(fid,'\nMean Grain Size (D50):  %12g mm\n',D50);
    
end

%% Functionality Table
fprintf(fid,'\n');
fprintf(fid,'\n**Functionality Table\n');
spaces_vector = zeros(1,70);
for i = 1:70
    spaces_vector(i) = ' ';
end
spaces_vector = char(spaces_vector);
%Outputs the correct message before the table
if func_choice == 1
    fprintf(fid,'This is the default compact functionality table you selected:\n');
    fprintf(fid,'\n');
elseif func_choice == 2
    fprintf(fid,'This is the default full functionality table you selected:\n');
    fprintf(fid,'\n');
elseif func_choice == 3
    fprintf(fid,'This is the custom functionality table you entered:\n');
    fprintf(fid,'\n');
end

for m = 1:n_chunks

    if m > 1
        fprintf(fid,'Functionality Table (continued)');
    end

    knuckle = find(char(final_rows(m,:)) ~= ' ');
    middle_knuckle = floor((knuckle(end)-knuckle(1))/2);
    titleRow = ['Ranges',spaces_vector(1,1:(middle_knuckle-10 + knuckle(1) - 5)),'Ecological Functions'];
    fprintf(fid,'%s\n',titleRow);
    fprintf(fid,'%s\n',char(final_rows(m,:)));

    %displaying the julian days
    i = 1;
    fprintf(fid,firstCol(i,:));
    for j=(1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
        for k=1:spaces(m)/2-1-3
            fprintf(fid,' ');
        end
        fprintf(fid,'%3.0f-%3.0f',start_day(j),end_day(j));
        for k=1:spaces(m)/2-3
            fprintf(fid,' ');
        end
    end
    fprintf(fid,'\n');

    %displaying the 1's and 0's
    for i=1:n_ranges
        fprintf(fid,firstCol(i+1,:));
        for j=(1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
            for k=1:spaces(m)/2-1
                fprintf(fid,' ');
            end
            fprintf(fid,num2str(matrix(i,j)));
            for k=1:spaces(m)/2
                fprintf(fid,' ');
            end
        end
        fprintf(fid,'\n');
    end %i loop
    fprintf(fid,'\n\n');
end %m loop



%% The meat and potatoes
fprintf(fid,'\n');
fprintf(fid,'**Scorecard\n');
fprintf(fid,'\nEF stands for Ecological Function, where:\n');

for i = 1:n_eco_func-1
    holder = find(eco_names(i,:) ~= 32);
    holder = char(eco_names(i,holder(1):holder(end)));
    
    fprintf(fid,'\tEF %3.0f is %s,\n',i,holder);
end

i = n_eco_func;
holder = find(eco_names(i,:) ~= 32);
holder = char(eco_names(i,holder(1):holder(end)));

fprintf(fid,'\tEF %3.0f is %s.\n',i,holder);
fprintf(fid,'\n           \t           \t           \t           \t');
fprintf(fid,'Geomorphic Functionality');
if n_eco_func <= 4
    fprintf(fid,'\tActual Functionality');
else
    for i = 5:n_eco_func
        fprintf(fid,'\t      ');
    end
    fprintf(fid,'\tActual Functionality');
end

if units == 1
    fprintf(fid,'\n  Julian Day\t     Q (cms)\t          T*\t          Q*');
else
    fprintf(fid,'\n  Julian Day\t     Q (cfs)\t          T*\t          Q*');
end

for i = 1:n_eco_func
    fprintf(fid,'\tEF %3.0f',i);
end

%make sure the E.F. starts at the right spot
if n_eco_func >= 4
    for i = 1:n_eco_func
        fprintf(fid,'\tEF %3.0f',i);
    end
else
    for i = 1:(4 - n_eco_func)
        fprintf(fid,'\t      ');
    end

    for i = 1:n_eco_func
        fprintf(fid,'\tEF %3.0f',i);
    end
end

fprintf(fid,'\n');

for i = 1:length(julian_day)
    fprintf(fid,'%12g\t%12g\t%12g\t%12g',...
        julian_day(i),Q(i),tau_star(i),Q_star(i));
    
    for j = 1:n_eco_func
        fprintf(fid,'\t   %1.0f  ',GMF(j,i));
    end
    
    %properly formatting the real functionality output
    if n_eco_func >= 4
        
        for j = 1:n_eco_func
            fprintf(fid,'\t   %1.0f  ',real_F(j,i));
        end %of j loop
    
    %case for n_eco_func less than 4
    else
        
        for j = 1:(4 - n_eco_func)
            fprintf(fid,'\t      ');
        end %of 1st j loop

        for j = 1:n_eco_func
            fprintf(fid,'\t   %1.0f  ',real_F(j,i));
        end %of 2nd j loop

    end %end of if statement for n_eco_func
    
    fprintf(fid,'\n');
    
end %end of i loop

%% Total Days Geomorphically Functional and Actually Functional
fprintf(fid,'\n');
fprintf(fid,'\n**Total Days Functional\n');
fprintf(fid,'where: EF stands for Ecological Function,\n');
fprintf(fid,'       GMF stands for Geomorphically Functional, and\n');
fprintf(fid,'       F stands for Functional.\n');
fprintf(fid,'\n          EF\t    Days GMF\t      Days F\n');

for i = 1:n_eco_func
    fprintf(fid,'%12g\t%12g\t%12g\n',i,total_days_GMF(i),...
        total_days_F(i));
end

fprintf(fid,'       Total\t%12g\t%12g\n',sum(total_days_GMF),sum(total_days_F));

%% Functional Flows
if tau_is_pos
    Q_store_test = log10(Q_star);
    t_store_test = log10(tau_star);

    p = polyfit(Q_store_test,t_store_test,1);

    q_test = linspace(-30,30,100);
    t_test = log10(tau_thresh);

    yp = polyval(p,q_test);

    for i = 1:length(tau_thresh)
        [Xo(i),Yo(i)] = mminvinterp(q_test,yp,t_test(i));
    end

    Xo = 10.^Xo;
end

fprintf(fid,'\n**Functional Flows\n');

fprintf(fid,'                   T* Range\t      Actual FF Range       \t Theoretical FF Range       \n');


for i = 1:n_ranges
    
    if i < n_ranges
        
        Q_range = find(t_store <= tau_thresh(i));
        Q_range = find(t_store(Q_range) > tau_thresh(i+1));
        
        fprintf(fid,'%12g - %12g\t',tau_thresh(i+1),tau_thresh(i));

        if isempty(Q_range)
            %actual
            fprintf(fid,'         NO FLOWS        \t');
        else
            %actual
            fprintf(fid,'%12g - %12g\t',min(Q_store(Q_range)),max(Q_store(Q_range)));
        end

        %theo
        if tau_is_pos
            fprintf(fid,'%12g - %12g',Xo(i+1),Xo(i));
            fprintf(fid,'\n');
        else
            fprintf(fid,'           N/A\n');
        end
        
        clear Q_range
        
    else
        
        Q_range = find(t_store <= tau_thresh(i));
        
        fprintf(fid,'             < %12g\t',tau_thresh(i));
                
        if isempty(Q_range)
            %actual
            fprintf(fid,'         NO FLOWS        \t');
        else
            %actual
            fprintf(fid,'%12g - %12g\t',min(Q_store(Q_range)),max(Q_store(Q_range)));
        end

        %theo
        if tau_is_pos
            fprintf(fid,'             < %12g',Xo(i));
            fprintf(fid,'\n');
        else
            fprintf(fid,'           N/A\n');
        end
        
        clear Q_range
        
    end %of ranges if
    
end % of i loop

%% Close the file
fclose(fid);